# Preface: Restoration of eutrophic lakes: current practices and future challenges

Tom Jilbert $\cdot$ Raoul-Marie Couture $\cdot$ Brian J. Huser $\cdot$ Kalevi Salonen

Accepted: 26 October 2020 / Published online: 16 November 2020   
$©$ Springer Nature Switzerland AG 2020

Abstract Eutrophication of lake ecosystems is a pervasive global environmental problem, exacerbated by urbanization, industrialization, and intensification of agriculture. Excess loading of the macronutrients nitrogen and phosphorus from a myriad of human activities in catchment areas has forced many lake ecosystems into turbid, eutrophic states from which natural recovery is slow. A wide array of tools is available to lake managers to accelerate the process of lake restoration. These range from external measures to reduce nutrient loading, to internal measures designed to either retain nutrients in sediments or remove them from the lake ecosystem. In this preface to the Special Issue Restoration of eutrophic lakes: current practices and future challenges, we briefly review the currently available approaches to lake restoration and assess their global prevalence through a literature survey. The results show that traditional restoration methods such as aeration and chemical inactivation of phosphorus by aluminum continue to be widely used and reported in the scientific literature. The popularity of biomanipulation appears to be in decline, while studies into newly developed, in-lake nutrient inactivation methods are expanding. Hypolimnetic withdrawal, on the other hand, remains a comparatively rare technique. The 16 original research articles in the Special Issue showcase the current state-of-the-art in knowledge of these approaches and their efficacy. We conclude by discussing the key relevant future challenges in the field of lake restoration science. Of these, the need to unite diverse fields of knowledge to develop quantitative models of lake ecosystem responses to restoration measures under a changing climate is paramount. We also emphasize the ongoing need for interaction between scientists, managers, and stakeholders in lake restoration.

Keywords Lake restoration $\cdot$ Nutrient loading $\cdot$ CyanoHABS $\cdot$ Aeration $\cdot$ Biomanipulation $\cdot$ Chemical

# inactivation $\cdot$ Hypolimnetic withdrawal $\cdot$ Climate change $\cdot$ Modeling

# Introduction

Lake ecosystems around the world are suffering the consequences of intense anthropogenic pressure. A recent report by the European Environment Agency concluded that only $40 \%$ of surface water bodies in Europe meet the criteria for good ecological status (Kristensen et al., 2018). Similar degradation of freshwater ecosystems is observed worldwide, with the timeline of human pressure dictated by trends in urbanization and intensive agriculture in different geographic regions (e.g., Vennemo et al., 2009). The principal driver of ecosystem stress in most aquatic systems is eutrophication, the excess growth of algae driven by anthropogenic inputs of the macronutrients nitrogen $( \mathrm { N } )$ and phosphorus (P) (Smith, 2003; Birk et al., 2020). Nutrients are emitted from both point and diffuse sources in the human environment and enter aquatic systems via surface runoff, as well as groundwater and atmospheric deposition (Paerl, 1997). Eutrophication often leads to the dominance of primary production by cyanobacteria, including toxic genera such as Dolichospermum, Aphanizomenon, and Microcystis (Huisman et al., 2018), as well as oxygen depletion and habitat degradation in lakes (Arend et al., 2011).

Because lakes provide a range of crucial ecosystem services (Wilson & Carpenter, 1999), there is a growing need for management approaches that restore water quality in freshwater systems. Within the framework of United Nations Sustainable Development Goal 6 (Clean Water and Sanitation), several distinct targets relate to the improvement of water quality and protection of aquatic ecosystems by 2030 (United Nations, 2015). Sustainable improvement of water quality rests upon scientific understanding of biogeochemical processes in lake ecosystems and their response to restoration actions. In turn, integration of this knowledge into management frameworks at national and international level is critical for the success of restoration projects. A key factor influencing lake management in the twenty-first century is climate change (Jeppesen et al., 2017), which is expected to modulate future aquatic biogeochemical cycles through altered patterns of precipitation and temperature (e.g., Sinha et al., 2017).

This Special Issue brings together contributions from participants of the symposium Lahti Lakes 2018 in Lahti, Finland, as well as more broadly from the global community working on the science of lake restoration. The aim of the Special Issue is to demonstrate the current state of knowledge within this community, both concerning biogeochemical cycles and their impact on components of lake ecosystems (e.g., factors controlling the prevalence of cyanobacterial blooms), as well as the range of currently available techniques for lake restoration and their efficacy. In this preface, we begin by summarizing the commonly applied strategies for lake restoration and investigate their prevalence by means of a literature survey. We then introduce the 16 original contributions before offering perspectives for the future.

# Commonly used strategies for lake restoration

External measures: reducing nutrient loading

Reduction of external nutrient loading is a fundamental premise for lake restoration (Jeppesen et al., 2005), and management efforts often focus on achieving this goal. However, lake catchments are characterized by large differences in hydrology, climate, geology, soils, land cover, and ecosystem type. Planning the reduction of external nutrient loading thus requires knowledge of these factors, as well as the primary nutrient sources in the catchment. Ideally, locally relevant solutions are developed by decision-makers and stakeholders liaising with scientists. Reductions are realized via modifying land use, agricultural and forestry practices (e.g., Marttila et al., 2020), as well as urban and sewage nutrient load reductions (Tong et al., 2020). Some measures target nutrients at large, for instance, by establishing buffer strips and erosion control measures, while others target specific elements (either N, P, or both), via emission reduction or targeted water treatments. Although P is typically the most cost-efficient target for nutrient abatement measures, dual-nutrient loading reductions (i.e., targeting both $_ \mathrm { N }$ and P) have been shown to further improve water quality (Paerl et al., 2016). It should be noted that efforts to manage external nutrient loads may alter the N:P ratio of effluents over long periods of time, with cascading effects on the stoichiometry of downstream lakes. This has recently been shown for waste water treatment (Tong et al., 2020) in particular, and it is possible that retention ponds—analogously to reservoirs in which water residence time and the extent of N-fixation controls P-burial (Maranger et al., 2018; Maavara et al., 2020)—may also artificially alter downstream nutrient ratios.

Internal measures aimed at removal of nutrients

# Biomanipulation

Biomanipulation of lake ecosystems based on food web theory (Shapiro et al., 1975) has been considered an attractive method to improve water quality due to its relative cost efficiency. Biomanipulation aims to control algal biomass and the prevalence of cyanobacterial blooms of eutrophic waters (Ibelings et al., 2016). The most commonly used approach is to enhance zooplankton by reduction of planktivorous fish or introduction of piscivores, although alternative methods have been used in some systems (Triest et al., 2016). When predation on zooplankton is reduced, grazing on phytoplankton increases and their biomass decreases. Consequent improved transparency of water promotes the growth of aquatic macrophytes which can remove large quantities of nutrients available for phytoplankton (e.g., Drenner & Hambright, 1999). The large-scale removal of fish biomass also directly removes nutrients from lake waters (Horppila et al., 1998).

The effects of biomanipulation have been reviewed in numerous publications (Jeppesen et al., 2012). Although the theory behind the approach has not been doubted, the success rate in published cases listed by Mehner et al. (2002) is only ca. $60 \%$ . Thus, taking into account that results of unsuccessful biomanipulation may have been less frequently published, the success rate may be lower still. Variation in the results of biomanipulation may derive from stochastic changes in hydrodynamics (Salonen et al., 2020) or in community composition, as well as the ontogeny and size distribution of species (Mehner et al., 2002). Differences in hydrography between lakes also have a strong influence on food chains and the mechanisms of nutrient regeneration from sediments (Mehner et al.,

2002). In large stratified lakes, positive results of biomanipulation are often only temporary (Søndergaard et al., 2008), thus necessitating repetition, but in shallow lakes, an alternative stable state may be reached through a single correctly planned treatment (Scheffer et al., 1993). Once aquatic macrophytes have become dominant among primary producers, their high biomass can buffer their competitiveness in the ecosystem over long time intervals. However, new results reported in this Special Issue suggest that anoxia during ice cover in winter can force the abrupt collapse of macrophyte communities in boreal lakes (Sarvala et al., 2020). Biomanipulation likely yields most favorable results when the total phosphorus (TP) concentration is below $5 0 ~ \mathrm { m g } ~ \mathrm { m } ^ { - 3 }$ in shallow lakes, and below $2 0 \mathrm { m g } \mathrm { m } ^ { - 3 }$ in deep lakes (Jeppesen et al., 2009). As for many in-lake techniques, biomanipulation typically works most effectively in combination with reduction of external nutrient loading (Kasprzak et al., 2007).

# Hypolimnetic withdrawal

In hypolimnetic withdrawal, part of the discharge of nutrient-poor epilimnetic water is replaced by nutrient-rich hypolimnetic water so that nutrient availability for epilimnetic primary producers is reduced (Nu¨rnberg, 1987). Water flow is usually driven by gravity so that the maintenance cost is very low, and the most cost-effective results can be obtained in late summer, when hypolimnetic nutrient concentrations are highest. The development of anoxic conditions and nutrient flux from the sediment may also be reduced by withdrawal earlier in the annual cycle, but then care should be taken not to affect water level or cause premature destratification during the productive season (Nu¨rnberg, 2020). A comprehensive set of results (Nu¨rnberg, 2007, 2020) shows that hypolimnetic withdrawal leads to a steady decrease in phosphorus and chlorophyll concentrations in the epilimnion, increases water transparency, and decreases phosphorus concentration as well as anoxia in the hypolimnion. However, in spite of its simple and economic operation, hypolimnetic withdrawal has been rarely applied, likely due to the major drawback that the method in its traditional form only moves the nutrient problem downstream. Thus, nutrient removal may be needed before withdrawn water can be led elsewhere or returned back to the same lake (Nu¨rnberg, 2020).

Internal measures aimed at fixation of nutrients

# Inactivation of legacy $P$ in lake sediment

The surface sediments of eutrophic lakes are often loaded with legacy $P$ , due to decades of accumulation from the catchment and internal regeneration in the sediment column (Carey & Rydin, 2011). This pool of $\mathrm { \bf P }$ is often easily mobilizable to participate in lake biogeochemical cycles, leading to a process known as internal loading (Orihel et al., 2017). Due to high contents of P, the sediments of eutrophic lakes often suffer from a lack of natural P-binding capacity, increasing the mobility of the surface-sediment P pool. Artificial enhancement of the sediment binding capacity for $\mathrm { \bf P }$ has thus been used as restoration measure since the late 1960s, with the first reported case being La˚ngsjo¨n, Sweden (Cooke et al., 2005). Often termed inactivation, this group of methods usually employ minerals that occur naturally in freshwater sedimentary environments.

A number of metals are used to inactivate sediment P, including aluminum (Al), iron (Fe), and calcium (Ca). When Fe is used to bind sediment P, it should be noted that supplemental aeration may be required (e.g., Engstrom, 2005) because Fe oxide minerals formed during the treatment are redox-sensitive and will release $\mathrm { \bf P }$ under oxygen-limited conditions. Ca addition, on the other hand, is typically best suited to high $\mathrm { p H }$ systems because Ca mineral formation and associated P-binding are generally more effective at high $\mathrm { p H }$ values (Stumm & Morgan, 1996). However, even in hard-water lakes, Ca-based treatments have had poor longevity (Reedyk et al., 2001). The most commonly used method to bind and inactivate sediment $\mathrm { \bf P }$ is the addition of aluminum (Al) salts, with treatments going back to the late 1960s (Huser et al., 2016a). Aluminum is not redox-sensitive and is most effective within a $\mathrm { p H }$ range of 6–9. There are two different methods used to apply Al to lakes, with the predominant approach being addition to the water column where the Al-mineral forms and precipitates, falling to the sediment surface where it naturally mixes with sediment over time due to bioturbation (Huser et al., 2016b). A newer method has been recently developed in which Al is injected directly to the sediment (Schu¨tz et al., 2017), which has been shown to increase binding efficiency of the newly added Almineral (Agstam-Norlin et al., 2020). Although effectiveness and longevity have varied over the years, mainly due to outdated dosing methods (Kuster et al., 2020), some treatments have reduced internal P loading significantly and the positive effects from correctly dosed treatments are expected to last over a century (Huser et al., 2016a).

A number of recently developed solutions are currently being tested as alternatives to the traditional binding methods. Many of these emerging solutions involve addition of P-binding metals to clay material that is then added to lake water and allowed to precipitate and mix with the sediment. Both lanthanum (e.g., PhoslockR, Spears et al., 2013) and Al (e.g., Yang et al., 2020) have been used to amend clay materials. Thermal treatment of Ca-based minerals has also been tested to determine if binding effectiveness can be improved (e.g., Yin & Kong, 2015), but this type of amendment has not been in use long enough to determine effectiveness and longevity. Combinations of metals/materials are also being tested, for example, ‘‘flock and lock,’’ which uses a combination of Al and lanthanum (La)-modified clay treatments to attempt to improve sediment P-binding and coagulation/precipitation of algal blooms with the clay material (e.g., Lu¨rling & van Oosterhout, 2013). Combinations of P-binding metals (Al and La) have also been used to amend clay material for use in sediment treatment (Yin et al., 2020). Even magnetic particles have been used to bind sediment P and reduce internal P loading (Funes et al., 2016). At the time of publication of this Special Issue, many of the above-mentioned methods have not been in use long enough to determine longterm effectiveness of treatment. All methods above have, however, shown promise in the short-term with varying levels of reduction of sediment P release.

# Hypolimnetic aeration/oxygenation

Hypolimnetic aeration involves the addition of oxygen to bottom waters to promote binding of sediment $\mathrm { \bf P }$ with oxides of redox-sensitive metals such as Fe and manganese (Mn). There are a number of methods to increase oxygen concentrations in bottom waters (e.g., Singleton & Little, 2006), including (1) removal, mechanical aeration and return of hypolimnetic water, (2) direct injection of air, (3) direct injection of oxygen, and (4) vertical mixing of oxic epilimnetic water into the hypolimnion. Aeration has historically been used to improve aquatic habitats in lakes with chronically low levels of oxygen, especially during winter in ice-covered lakes, and its first reported use was in Lake Bret, Switzerland (Mercier & Perret, 1949). Some historical cases of aeration have shown positive long-term results, most often when the technique is applied in combination with P-binding metals like Al, Fe, or in some cases Ca (see review in Cooke et al., 2005). In such cases, hypolimnetic aeration may contribute to large reductions in sediment P release (e.g., up to $90 \%$ , Walker et al., 1989). However, many studies have questioned the efficacy of aeration itself, including several in this Special Issue (e.g., Chorus et al., 2020; Niemisto¨ et al., 2020; Ruuhija¨rvi et al., 2020; Taipale et al., 2020). For example, destabilization of the thermocline and increased bottom water temperatures can lead to increased sediment $\mathrm { \bf P }$ release and/or transport to surface waters. Underperforming systems have led to failed restorations, highlighting that the design of such systems must take into account both sediment oxygen demand and risk for water-column destabilization (Cooke et al., 2005). Another limitation is that there is often a lack of sufficient sediment P retention capacity, even if oxygen levels in the bottom water remain elevated, and thus addition of P-binding materials is often needed in order for aeration to be successful (e.g., Walker et al., 1989; Engstrom, 2005).

# Literature trends in lake restoration research

To objectively assess the prevalence of scientific studies into lake restoration measures worldwide, we performed a survey of publications over the period 1970–2020 in ISI Web of Science using a range of relevant search terms for publication title (Fig. 1). The results show that publications in lake restoration science overall are increasing, with over 30 publications per year in the period of 2016–2019 featuring $L a k e ^ { * } +$ restoration in the title. A general upwards trend over the entire period is also observed in studies featuring $L a k e ^ { * } +$ aeration/oxygenation and $L a k e ^ { * } +$ alum\* in the title, implying that studies on aeration and traditional chemical treatment methods have expanded similarly to the field as a whole. Interestingly, $L a k e ^ { * } +$ biomanipulation in title shows a decline since the 1990s, suggesting overall decrease in popularity of studies into this approach. In contrast, $L a k e ^ { * } +$ lanthanum/Phoslock in title shows a clear recent upsurge, presumably related to the recent development of new chemical inactivation methods. Hypolimnetic withdrawal features in only a small number of titles spread over several decades, highlighting the relative scarcity of studies into this technique, at least when referred to by this name.

![](images/5f30befc2f2b36abbd3961bfde9f0e9e363db88796eecc2c88d29af24795f98f.jpg)  
Fig. 1 Number of articles published per year in all ISI-listed journals containing selected keywords related to lake restoration in the title (1970–2020)

# Summary of original contributions to the Special Issue

The articles in this Special Issue fall broadly into three groups based on their perspective on the topic of lake restoration (Table 1). Here, we provide a brief overview of each group and the content of each contribution.

Table 1 List of original contributions to the Special Issue   

<html><body><table><tr><td>Perspective</td><td>Author</td></tr><tr><td>Understanding lake biogeochemical cycles</td><td>Paerl et al. (2020)</td></tr><tr><td></td><td>Kuha et al. (2020)</td></tr><tr><td></td><td>Vuorio et al. (2020)</td></tr><tr><td></td><td>Jilbert et al. (2020)</td></tr><tr><td></td><td>Beutel et al. (2020)</td></tr><tr><td>Examples of specific restoration measures and evaluation of success</td><td>Lirling &amp; Mucci (2020)</td></tr><tr><td></td><td>Weber et al. (2020)</td></tr><tr><td></td><td>Nuirnberg (2020)</td></tr><tr><td></td><td>Ruuhijarvi et al. (2020)</td></tr><tr><td></td><td>Niemisto et al. (2020)</td></tr><tr><td></td><td>Taipale et al. (2020)</td></tr><tr><td></td><td>Rask et al. (2020)</td></tr><tr><td>Long-term studies of restoration actions as reference cases for lake managers</td><td>Sarvala et al. (2020)</td></tr><tr><td></td><td>Salonen et al. (2020)</td></tr><tr><td></td><td>Chorus et al. (2020)</td></tr><tr><td></td><td>Shirokova et al. (2020)</td></tr></table></body></html>

Understanding lake biogeochemical cycles

The first group of articles (5) deals broadly with the topic of understanding lake biogeochemical cycles as a prerequisite for planning restoration strategies. This group includes an opinion paper emphasizing the need for dual (N and P) nutrient loading reduction strategies (Paerl et al., 2020), methodological developments in the quantification of chlorophyll concentrations (Kuha et al., 2020), and empirical analysis of phosphorus thresholds for cyanobacterial blooms (Vuorio et al., 2020), as well as detailed studies of sediment biogeochemical processes impacting on phosphorus and mercury cycling (Beutel et al., 2020; Jilbert et al., 2020).

One of the most distinctive phenomena associated with lake eutrophication is the prevalence of cyanobacterial harmful algal blooms (CyanoHABs). Paerl et al. (2020) draw attention to the fact that the occurrence of CyanoHABS in many large lake ecosystems today is sensitive primarily to $_ \mathrm { N }$ inputs. For example, the authors present bioassays showing that summer-fall blooms of toxic Microcystis in Lake Taihu, China, are more sensitive to N than to P inputs.

Paerl et al. emphasize that systems characterized by non-diazotrophic cyanobacteria such as Microcystis do not behave according to the paradigm of strict $\mathrm { \bf P }$ limitation that has guided lake management strategies over previous decades, and therefore that dual-nutrient management is essential for planning restoration of eutrophic lakes in future. The authors also reiterate that the N balance of lake ecosystems is sensitive to system-scale denitrification as well as diazotrophy (Scott et al., 2019), and that large anthropogenic legacies of both N and P are present in the catchments of many eutrophic lakes.

Kuha et al. (2020) present results from a calibration exercise aimed at deconvolving the effect of nonphytoplankton organic matter (OM) on sensor-based measurements of chlorophyll- $^ a$ , traditionally used as a proxy for phytoplankton biomass in lakes. Poor correlations between discrete-sample and sensorbased chlorophyll measurements have often been observed in boreal lakes characterized by high concentrations of humic substances, demanding improved protocols for correction of sensor data. Kuha et al. test a number of distinct calibration models for such corrections in a set of 14 Finnish lakes, based on either water color or OM fluorescence data. As expected, each approach greatly improves the regression between discrete-sample and sensor-based chlorophyll data. However, a key finding was that a single value representing the typical water color in a given lake gives similarly good results to parallel measurements of OM fluorescence at the time of chlorophyll sampling, offering a potentially efficient solution to the large-scale correction of data. The authors also show that a time series of sensor-based chlorophyll data through one entire growth season reliably reproduces the range of values observed in discrete samples, despite variable OM concentrations.

The study of Vuorio et al. (2020) investigates the TP thresholds for cyanobacterial blooms in a set of $>$ 2,000 Finnish lakes, in the context of refining targetsetting for nutrient load reductions. The authors use a segmented regression approach to show that when considering all data together (including all cyanobacterial genera and lake types), a value of $3 0 \mu \mathrm { g } / 1$ TP may be considered critical for triggering cyanobacterial blooms. However, there are significant differences between genera. For example, Planktothrix TP thresholds were among the lowest of the studied genera, while Microcystis were among the highest. Moreover, polyhumic lakes showed typically higher TP thresholds for all genera, attributed by the authors to low bioavailability of $\mathrm { \bf P }$ bound in humic substances. Accordingly, the estimated TP threshold for Planktothrix in an oligohumic lake is $1 0 ~ \mu \mathrm { g } / 1$ TP, whereas for Microcystis in a polyhumic lake the value is $6 0 \mu \mathrm { g } / 1$ TP. Considering the variable toxicity of the different cyanobacterial genera (as listed in Paerl et al., 2020), this information will be of great use for risk assessment by lake managers setting water quality goals. The authors highlight that brownification of boreal waters will modify the concentrations of humic substances in future and therefore also the expected TP threshold for cyanobacteria. Furthermore, they caution that variables other than TP may control the prevalence of certain cyanobacteria genera. Vuorio et al. echo the observations of Paerl et al. (2020) that genera such as Microcystis can self-regulate their $\mathrm { \bf P }$ supply by vertical migration in the water column and thus are not dependent on epilimnetic P availability as expressed by TP data.

Many past studies have emphasized the importance of legacy P in lake sediments in delaying the recovery from eutrophication (e.g., Hupfer & Lewandowski, 2008 and references therein). In this issue, Jilbert et al. (2020) present a novel biogeochemical dataset from long sediment cores from Lake Vesija¨rvi to investigate the role of ongoing microbial processes in the deep sediment layers in controlling modern P cycling in the lake. The authors show that a sediment layer deposited at the height of past eutrophication in the late twentieth century is still diagenetically active below the sediment surface. Microbial remineralization of organic matter releases P from this layer into the porewaters, from where it can diffuse towards the sediment surface and influence lake biogeochemical cycles. The novelty of the study lies in the investigation of sediment layers usually considered to be buried below the ‘‘active’’ horizon. The authors propose that similar phenomena may be observed in other lakes with high sedimentation rates and eutrophication histories, calling on the research community to employ a more comprehensive approach to sediment biogeochemistry studies in eutrophic lakes.

Beutel et al. (2020) demonstrate that anoxic conditions in sediments and deep waters of eutrophic water bodies modify their chemical characteristics profoundly, with impacts beyond the often-studied enhanced recycling of P and N. The authors carried out a study into the biogeochemical consequences of hypolimnetic anoxia in Hodges Reservoir, California. The study was performed partly in the context of assessing the potential effects of oxygenation in the reservoir, which serves as a water supply for two districts of the City of San Diego. Beutel et al. performed incubations of sediments under a range of oxygen conditions and measured the accumulation of reduced chemical species in the overlying water. They show that anoxic conditions favor the release not only of P, but also methylmercury $\mathrm { ( M e H g ) }$ , a toxic form of mercury produced during sulfate reduction in anoxic sediments, as well as soluble manganese (Mn). The authors conclude that hypolimnetic oxygenation could be beneficial for reducing the accumulation of these substances in the water column, which is important for water quality goals in the reservoir. However, they caution that the sediment oxygen demand may present a significant obstacle to maintaining oxic conditions at the sediment–water interface throughout the year, and that the potential of the sediments to permanently bind P is low even under oxic conditions. As such, the study highlights the difficulties in managing the biogeochemical consequences of rapid sediment accumulation in reservoirs.

# Examples of specific restoration measures and evaluation of success

The second group of articles (7) includes studies in which a specific restoration measure (or measures) is evaluated in terms of success in achieving goals of water quality improvement. The group includes two meta-analytical studies in which various measures applied to lakes within a given geographical region are compared (Lu¨rling & Mucci, 2020 for the Netherlands; Weber et al., 2020 for Iowa, USA). One article presents a review of existing worldwide examples of hypolimnetic withdrawal, as well as a feasibility study for its new application in Lake Borsjo¨n, Sweden (Nu¨rnberg, 2020). The remaining studies assess the influence of various restoration measures, including aeration and biomanipulation, on food webs and biogeochemical cycles in two heavily human-impacted Finnish Lakes, Vesija¨rvi and Tuusulanja¨rvi (Niemisto¨ et al., 2020; Rask et al., 2020; Ruuhija¨rvi et al., 2020; Taipale et al., 2020).

Freshwater systems in the Netherlands are typically shallow and heavily eutrophied by diffuse loading from agriculture, leading to a high prevalence of cyanoHABs. Lu¨rling & Mucci (2020) present a review of physical, chemical and biological measures employed within Dutch lakes and ponds to combat cyanoHABs. They show that most physical measures employed so far, including fountains, oil screens, ultrasound, sediment dredging and harvesting of macrophytes, have been largely ineffective. Lu¨rling & Mucci also refer to the potential use of hypolimnetic withdrawal but no examples are available to judge its success in shallow Dutch lakes. In terms of chemical measures, the authors distinguish between approaches directly targeting cyanoHABs, including algaecides, and those aimed at retention of $\mathrm { \bf P }$ in sediments, for example iron chloride $\left( \mathrm { F e C l } _ { 3 } \right)$ and PhoslockR. Of the algaecides, hydrogen peroxide is commonly and successfully applied in Dutch lakes to reduce bloom densities below safe levels for recreation. PhoslockR shows effective retention of $\mathrm { \bf P }$ in sediments, but its relatively high costs must be balanced against the economic gain of improved water quality. Finally, of the biological measures the authors conclude that successful biomanipulation is most likely to be achieved through management of benthivorous fish stocks. However, as shown by several previous studies, large-scale reductions of these stocks are required to enable a clear water state favoring establishment of macrophytes.

Lake restoration studies are often limited by the absence of controls or references against which success can be compared. The approach of Weber et al. (2020) represents an interesting exception in which 20 restored lakes were studied together with reference lakes for up to 11 years throughout Iowa, USA. A variety of restoration methods or combination of methods was included in the study. The authors observed that Secchi depth generally improved after restoration, while nutrient and plankton concentrations also tended to decrease, but the effects were variable and sometimes short-lived. Weber et al. conclude that the long degradation history and legacy effects of nutrient-rich soils in Iowa made detection of systematic effects of restoration measures challenging. The heterogeneity of the results also indicated a need to understand lake-specific mechanisms controlling the likelihood of achieving sustainable improvements in water quality.

In reviewing past and current examples of hypolimnetic withdrawal, Nu¨rnberg (2020) highlights that this approach, despite its relative rarity (Fig. 1), should be reconsidered in future. Historical applications have been successful when combined with passive water extraction by gravity, in lakes experiencing strong stratification. Unfortunately, the quality of the extracted water often did meet water quality guidelines, leading to the end of operations. Modern applications are thus especially promising when combined with water treatment. The case study of Lake Bornsjo¨n leads Nu¨rnberg (2020) to recommend that appropriate timing of the withdrawal and back-routing of treated hypolimnetic water be used to reduce internal loading while avoiding destratification. In the context of ongoing climate change, Nu¨rnberg (2020) argues that such methods might be preferable to in situ treatment restoration methods more vulnerable to climaterelated unpredictability.

The remaining studies in this section focus on two heavily human-impacted lakes in Finland, namely, Vesija¨rvi and Tuusulanja¨rvi. Lake Vesija¨rvi, located close to the site of the Lahti Lakes 2018 symposium, has a long history of restoration efforts, the most recent of which focused on the installation of a network of hypolimnetic oxygenation pumps. Ruuhija¨rvi et al. (2020) studied the responses of plankton food webs to this hypolimnetic oxygenation program, in which epilimnetic water was pumped into the hypolimnion in nine locations throughout the lake. The structure of the pelagic food web experienced several changes in response. The most striking feature was the development of a dense smelt population dominated by young-of-the-year individuals. This led to a decrease in cladoceran body size through predation pressure and consequently reduced grazing on phytoplankton. Through these cascading effects, the oxygenation program may ultimately have contributed to the occurrence of cyanoHAB episodes, thus contradicting with the aim to prevent their occurrence in Lake Vesija¨rvi.

Complex interplays between thermal stratification, oxygen availability and carbon degradation in response to the same hypolimnetic oxygenation program are highlighted by Niemisto¨ et al. (2020). The oxygenation approach aims at dampening redoxdependent $\mathrm { \bf P }$ release by allowing excess oxygen to degrade organic carbon and maintain oxidizing conditions at the sediment–water interface. The authors highlight that pumping of oxygen-rich water from the surface to the hypolimnion does enhance carbon oxidation, but also favors sediment resuspension and weakens thermal stratification, which together supply particulate $\mathrm { \bf P }$ to the water column. They provide evidence that although the approach lowers internal P loading, it is not likely to result in a shift of the lake’s overall trophic status towards better water quality.

Taipale et al. (2020) studied the response of food quality in phytoplankton and subsequent changes to the zooplankton community to both the hypolimnetic oxygenation program, and earlier biomanipulation measures, in Lake Vesija¨rvi. They point out that food quality of phytoplankton can be a complimentary method for evaluating restoration success. Taipale et al. show that biomanipulation (in this case mass removal of planktivorous fish, 1989–1993) increased the abundance of EPA- and DHA-producing phytoplankton, which are considered to be of better food quality for zooplankton, especially for species such as Daphnia. Hypolimnetic oxygenation, on the other hand, did not drive similar, positive effects and instead appeared to cause some undesirable responses to both phytoplankton and zooplankton communities. The authors suggest that this was most likely due to increased water temperature in the hypolimnion and turbulence, both leading to enhanced P recycling and degradation of organic matter, also noted in previous work (Salmi et al., 2014; Niemisto¨ et al., 2016). Topdown control thus proved to be more successful at improving the biological community in Lake Vesija¨rvi. However, the positive effects of biomanipulation were short-lived, with cyanobacteria again dominating the phytoplankton community after approximately eight years.

Rask et al. (2020) followed fish community responses to mass removal of planktivorous fish from Lake Tuusulanja¨rvi over a period of 23 years. In agreement with Hansson & Bro¨nmark (2009) they found that effective reproduction and growth responses of fish largely compensated for the effects of mass removal, resulting in continuously high fish biomass in the lake. However, the continuous removal of nutrients was concluded to have contributed to moderate improvements in water quality over the study period. Occasional clay turbidity in rainy years hampered effective fish removal, reducing the overall catch. The authors also compared methods for monitoring the fish community and concluded that no single method yielded a comprehensive evaluation, thus recommending a combination of methods including gillnets, echo sounding and virtual population analysis (VPA).

# Long-term studies of restoration actions as reference cases for lake managers

The final group of articles (4) are connected by the fact that they provide detailed case studies of individual lake systems that have undergone several phases of restoration actions in response to human-induced pressures. Such case studies can be invaluable for lake managers in assessing the potential longevity and side effects of planned restoration actions, as well as factors complicating ecosystem responses. This section includes two studies focused on lakes in Finland, including the small urban Lake Littoistenja¨rvi (Sarvala et al., 2020) as well as a comprehensive overview of restoration actions in Lake Vesija¨rvi (Salonen et al., 2020). The third case study is focused on Lake Tegel, Germany (Chorus et al., 2020), while the fourth deals with a system of small boreal lakes in NW Russia (Shirokova et al., 2020). Each of these systems has a distinct history of eutrophication and management responses, but all are characterized by regular monitoring programs allowing the relative success of different actions in each system to be assessed.

Sarvala et al. (2020) found that fluctuating mass occurrences of the invasive macrophyte Elodea canadensis Michx controlled the alternation between turbid and clear water states of Lake Littoistenja¨rvi. Macrophyte dynamics were thus concluded to dominate over specific restoration actions in determining the water quality on a multi-annual timescale. Collapses in macrophyte biomass from peak values led to under-ice anoxia in winter and increased nutrient leaching from the sediment. After ice melting, mass blooms of cyanobacteria limited light penetration into the water, while increased pH due to high photosynthesis accentuated the liberation of nutrients from the sediment. These conditions favored the development of a turbid water state for several years following each Elodea collapse. Internal loading could not be controlled by external load reduction, aeration or intensive fish removal. Instead, polyaluminum chloride treatment proved promising to reduce internal loading and restore the clear water state for several years.

Among various restoration measures adopted in Lake Vesija¨rvi over almost half a century, reduction of external nutrient loading played the dominant role in influencing water quality (Salonen et al., 2020). The principal measure to reduce external loading was the construction of a waste water treatment plant in Lahti in 1976. However, mass removal of planktivorous and benthivorous fish, together with pikeperch stocking, accelerated the recovery by a few years and sustainable fisheries and the recreational value of the lake were re-established in about 25 years following the waste water diversion. In spite of this, the lake remained eutrophic with cyanobacterial blooms and usually low hypolimnetic oxygen concentration. The extensive long-term oxygenation program in Lake Vesija¨rvi greatly improved hypolimnetic oxygen and nutrient concentrations, but no respective effects were detected in the epilimnion. Salonen et al. highlight that eliciting effects of specific remediation measures requires long-term and multifaceted monitoring.

Chorus et al. (2020) describe the effects of a 40-fold reduction in external loading in Lake Tegel, Germany by analyzing 35 years of pre- and post-treatment data. To achieve the drastic reduction in external loading, precipitation of P in the two main tributaries to the lake was conducted using iron (Fe) and aluminum (Al) salts. TP decreased from a pre-treatment mean of nearly $7 0 0 ~ \mu \mathrm { g } / 1$ to a mean of $2 9 ~ \mu \mathrm { g } / 1$ in 1994. Values increased again, however, (to mean $6 4 ~ \mu \mathrm { g } / \mathrm { l }$ ) due to reduced treatment of inflowing water to the lake from 1997–2001. During 2002, treatment was optimized to again increase the amount of P stripping, and summer mean values of TP decreased to approximately $2 0 \mu \mathrm { g } / 1$ from 2002 to 2016. The sharp decline in in-lake P led to improvement in plankton community composition (e.g., switch in dominance from cyanobacterial blooms to eukaryotic algae) and macrophyte coverage and diversity increased substantially, suggesting effective bottom-up control. The authors discuss the factors that may have influenced the sharp and effective decrease of $\mathrm { \bf P }$ in the lake. Although 15 bubble plume aerators were installed in the main basin of the lake prior to external load reduction, these were considered to have a minimal or even negative effect on surface TP concentrations, for similar reasons outlined in Niemisto¨ et al. (2020): destabilized stratification leading to higher bottom water temperatures, thus likely increasing the degradation rate of organic matter and $\mathrm { \bf P }$ mineralization. Rather, the short residence time of the lake was likely the key reason for success of external loading reduction in this system. In Lake Tegel, the entire lake volume is flushed by lowTP water approximately 4 times a year, giving a water residence time less than 3 months and therefore a high potential removal rate of P remobilized internally from sediments. This conclusion is supported by sediment data showing that the amount of mobile sediment $\mathrm { \bf P }$ was relatively low compared to external P loading, and that sediments were only a source of $\mathrm { \bf P }$ to the lake during the first few years after external loading reduction (Schauser & Chorus, 2009).

Finally, Shirokova et al. (2020) provide evidence for a shifting baseline in boreal lakes impacted by past atmospheric deposition. While the study does not focus on remediation measures, it shows that the ongoing evolution of water quality in boreal lakes should be accounted for in planning future management. The authors highlight that, on the one hand, recent decades have been characterized by declining human impact on many boreal lakes with respect to nutrients, metals and metalloids, effectively reducing external loads, while, on the other hand, dissolved organic carbon (DOC) concentrations and climate effects are generally increasingly modulating lake water quality. In a set of lakes from Russia’s Onega River basin, the authors demonstrate that increasing external inputs of DOC are, however, not ubiquitous. Combined with a review of several regional and continental scale studies, Shirokova et al. make the case that accounting for site-specific long-term trends is a key aspect of planning lake recovery. This is achieved by better documenting the physical, chemical, and biological inter-annual variability of sentinel lakes.

# Future perspectives

This Special Issue documents the current state of the art in lake restoration science. Many of the studies show that sustainable lake restoration is difficult to achieve, often due to long legacy effects of past nutrient inputs and shifting baselines in lake trophic state. While these concepts have been discussed for decades (e.g., Dent et al., 2002; Duarte et al., 2009), it is clear that detailed projections of the success of planned restoration measures remain challenging. Representation of critical processes such as sediment P diagenesis and water-column dynamics in response to changes in external pressures can be undertaken with simple models (Katsev, 2017). However, given the range of interconnected processes driving lake response to external and internal factors, detailed process-based models are promising tools when available (Spears et al., 2017). For the purpose of planning lake restoration, accounting for hydrodynamics, ecosystem functioning and sediment processes may be necessary (Trolle et al., 2011; Smits & van Beek, 2013; Hipsey et al., 2015; Zhang et al., 2015; Hu et al., 2016). Recently, the coupling of stateof-the-art lake models (Hipsey et al., 2020; Rousso et al., 2020) with sediment diagenetic models (e.g., Gudimov et al., 2016; Matisoff et al., 2016; Doan et al., 2018) has been promoted specifically to address gaps in lake resaturation planning (Markelov et al., 2019; Messina et al., 2020). A key future perspective is thus the improved integration of the required modeling infrastructure to test different restoration scenarios.

Climate change is a critical context impacting on developments in lake restoration science in the future. Changing air temperature and precipitation patterns may worsen eutrophication by promoting increases in both external (Sinha et al., 2017) and internal (Orihel et al., 2017) nutrient loads. Hence, the climateproofing of remediation measures becomes essential to ensure their success. In line with climate change, pressures such as increasing DOC concentrations and external nutrient fluxes cause nonlinear responses in epilimnetic temperature and water-column biogeochemistry. Given this complexity, once more we emphasize that numerical models will be essential tools to capture the response of water quality variables to external pressures (e.g., Spears et al., 2017). A significant body of literature exists on the potential effects of climate change on cyanoHABs (Burford et al., 2020). Nevertheless, critical gaps remain in the quantification of other key system components, such as internal nutrient loading, under environmental change (Me et al., 2018).

While climate change impacts on all regions of the globe, we emphasize that the timeline of eutrophication and subsequent restoration actions may vary greatly. Thus, the priorities of lake restoration may differ from region to region. For example, in historically industrialized regions, such as Europe and North America, direct nutrient loading to many lakes is now in decline due to environmental legislation. Yet, lakes and their catchments in these regions have accumulated significant pools of legacy nutrients due to past inputs (Sharpley et al., 2013; Van Meter et al., 2016). Hence, the focus of restoration in industrialized regions is often on managing a long-term recovery rather than preventing further worsening of the situation, unless forced by climate change. Conversely, in industrializing regions, the goal of lake restoration may indeed be to prevent the worst effects of nutrient loading before they emerge. In all cases, the chances of successful restoration are greatly improved by an integrated long-term approach in which scientists, managers, and stakeholders are all engaged from the beginning.

Acknowledgements The Guest Editorial Team acknowledges Lake Vesija¨rvi Foundation for partnership during the organization of Lahti Lakes 2018. All participants of the symposium are acknowledged for their contributions to the discussions that led to the creation of this Special Issue. All authors and reviewers of the 16 original research articles are greatly acknowledged for their work.

# Compliance with ethical standards

Conflict of interest The authors declare that they have no conflicts of interest.

# References

Agstam-Norlin, O., E. E. Lannerga˚rd, M. N. Futter & B. J. Huser, 2020. Optimization of aluminum treatment efficiency to control internal phosphorus loading in eutrophic lakes. Water Research 185: 116150.   
Arend, K. K., D. Beletsky, J. V. DePinto, S. A. Ludsin, J. J. Roberts, D. K. Rucinski, D. Scavia, D. J. Schwab & T. O. Hoeoek, 2011. Seasonal and interannual effects of hypoxia on fish habitat quality in central Lake Erie. Freshwater Biology 56: 366–383.   
Beutel, M., B. Fuhrmann, G. Herbon, A. Chow, S. Brower & J. Pasek, 2020. Cycling of methylmercury and other redoxsensitive compounds in the profundal zone of a hypereutrophic water supply reservoir. Hydrobiologia. https://doi. org/10.1007/s10750-020-04192-3.   
Birk, S., D. Chapman, L. Carvalho, B. M. Spears, H. E. Andersen, C. Argillier, S. Auer, A. Baattrup-Pedersen, L. Banin, M. Bekliog˘lu, E. Bondar-Kunze, A. Borja, P. Branco, T. Bucak, A. D. Buijse, A. C. Cardoso, R. Couture, F. Cremona, D. de Zwart, C. K. Feld, M. T. Ferreira, H. Feuchtmayr, M. O. Gessner, A. Gieswein, L. Globevnik, D. Graeber, W. Graf, C. Gutie´rrez-Canovas, J. Hanganu, U. Iskin, M. Ja¨rvinen, E. Jeppesen, N. Kotama¨ki, M. Kuijper, J. U. Lemm, S. Lu, A. L. Solheim, U. Mischke, S. J. Moe, P. No˜ges, T. No˜ges, S. J. Ormerod, Y. Panagopoulos, G. Phillips, L. Posthuma, S. Pouso, C. Prudhomme, K. Rankinen, J. J. Rasmussen, J. Richardson, A. Sagouis, J. M. Santos, R. B. Scha¨fer, R. Schinegger, S. Schmutz, S. C. Schneider, L. Schu¨lting, P. Segurado, K. Stefanidis, B. Sures, S. J. Thackeray, J. Turunen, M. C. Uyarra, M. Venohr, P. C. von der Ohe, N. Willby & D. Hering, 2020. Impacts of multiple stressors on freshwater biota across spatial scales and ecosystems. Nature Ecology and Evolution 4: 1060–1068.   
Burford, M. A., C. C. Carey, D. P. Hamilton, J. Huisman, H. W. Paerl, S. A. Wood & A. Wulff, 2020. Perspective: advancing the research agenda for improving understanding of cyanobacteria in a future of global change. Harmful Algae 91: 101601.   
Carey, C. C. & E. Rydin, 2011. Lake trophic status can be determined by the depth distribution of sediment phosphorus. Limnology and Oceanography 56: 2051–2063.   
Chorus, I., A. Ko¨hler, C. Beulker, J. Fastner, K. van de Weyer, T. Hegewald & M. Hupfer, 2020. Decades needed for ecosystem components to respond to a sharp and drastic phosphorus load reduction. Hydrobiologia. https://doi.org/ 10.1007/s10750-020-04450-4.   
Cooke, G. D., E. B. Welch, S. A. Peterson & S. A. Nichols, 2005. Restoration and Management of Lakes and Reservoirs. Taylor and Francis/CRC Press, Boca Raton: 616.   
Dent, C., G. Cumming & S. Carpenter, 2002. Multiple states in river and lake ecosystems. Philosophical Transactions of the Royal Society B-Biological Sciences 357: 635–645.   
Doan, P. T. K., S. B. Watson, S. Markovic, A. Liang, J. Guo, S. Mugalingam, J. Stokes, A. Morley, W. Zhang, G. B. Arhonditsis & M. Dittrich, 2018. Phosphorus retention and internal loading in the Bay of Quinte, Lake Ontario, using diagenetic modelling. Science of the Total Environment 636: 39–51.   
Drenner, R. W. & K. D. Hambright, 1999. Review: biomanipulation of fish assemblages as a lake restoration technique. Archiv fu¨r Hydrobiologie 146: 129–165.   
Duarte, C. M., D. J. Conley, J. Carstensen & M. Sa´nchez-Camacho, 2009. Return to Neverland: shifting baselines affect eutrophication restoration targets. Estuaries and Coasts 32: 29–36.   
Engstrom, D., 2005. Long-term changes in iron and phosphorus sedimentation in Vadnais Lake, Minnesota, resulting from ferric chloride addition and hypolimnetic aeration. Lake and Reservoir Management 21: 96–106.   
Funes, A., J. de Vicente, L. Cruz-Pizarro, I. A´ lvarez-Manzaneda & I. de Vicente, 2016. Magnetic microparticles as a new tool for lake restoration: a microcosm experiment for evaluating the impact on phosphorus fluxes and sedimentary phosphorus pools. Water Research 89: 366–374.   
Gudimov, A., J. McCulloch, J. Chen, P. Doan, G. Arhonditsis & M. Dittrich, 2016. Modeling the interplay between deepwater oxygen dynamics and sediment diagenesis in a hardwater mesotrophic lake. Ecological Informatics 31: 59–69.   
Hansson, L. A. & C. Bro¨nmark, 2009. Biomanipulation of aquatic ecosystems. In Likens, G. E. (ed.), Encyclopedia of Inland Waters. Elsevier, Amsterdam: 55–60.   
Hipsey, M. R., D. P. Hamilton, P. C. Hanson, C. C. Carey, J. Z. Coletti, J. S. Read, B. W. Ibelings, F. J. Valesini & J. D. Brookes, 2015. Predicting the resilience and recovery of aquatic systems: a framework for model evolution within environmental observatories. Water Resources Research 51: 7023–7043.   
Hipsey, M. R., G. Gal, G. B. Arhonditsis, C. C. Carey, J. A. Elliott, M. A. Frassl, J. H. Janse, L. de Mora & B. J. Robson, 2020. A system of metrics for the assessment and improvement of aquatic ecosystem models. Environmental Modelling and Software 128: 104697.   
Horppila, J., H. Peltonen, T. Malinen, E. Luokkanen & T. Kairesalo, 1998. Top-down or bottom-up effects by fish: issues of concern in biomanipulation of lakes. Restoration Ecology 6: 20–28.   
Hu, F., K. Bolding, J. Bruggeman, E. Jeppesen, M. R. Flindt, L. van Gerven, J. H. Janse, A. B. G. Janssen, J. J. Kuiper, W. M. Mooij & D. Trolle, 2016. FABM-PCLake – linking aquatic ecology with hydrodynamics. Geoscientific Model Development 9: 2271–2278.   
Huisman, J., G. A. Codd, H. W. Paerl, B. W. Ibelings, J. M. H. Verspagen & P. M. Visser, 2018. Cyanobacterial blooms. Nature Reviews Microbiology 16: 471–483.   
Hupfer, M. & J. Lewandowski, 2008. Oxygen controls the phosphorus release from lake sediments – a long-lasting paradigm in limnology. International Review of Hydrobiology 93: 415–432.   
Huser, B. J., S. Egemose, H. Harper, M. Hupfer, H. Jensen, K. M. Pilgrim, K. Reitzel, E. Rydin & M. Futter, 2016a. Longevity and effectiveness of aluminum addition to reduce sediment phosphorus release and restore lake water quality. Water Research 97: 122–132.   
Huser, B. J., M. Futter, J. T. Lee & M. Perniel, 2016b. In-lake measures for phosphorus control: the most feasible and cost-effective solution for long-term management of water quality in urban lakes. Water Research 97: 142–152.   
Ibelings, B. W., J. Fastner, M. Bormans & P. M. Visser, 2016. Cyanobacterial blooms. Ecology, prevention, mitigation and control: Editorial to a CYANOCOST Special Issue. Aquatic Ecology 50: 327–331.   
Jeppesen, E., M. Søndergaard, J. Jensen, K. Havens, O. Anneville, L. Carvalho, M. Coveney, R. Deneke, M. Dokulil, B. Foy, D. Gerdeaux, S. Hampton, S. Hilt, K. Kangur, J. Ko¨hler, E. Lammens, T. Lauridsen, M. Manca, M. Miracle, B. Moss, P. No˜ges, G. Persson, G. Phillips, R. Portielje, C. Schelske, D. Straile, I. Tatrai, E. Willen & M. Winder, 2005. Lake responses to reduced nutrient loading – an analysis of contemporary long-term data from 35 case studies. Freshwater Biology 50: 1747–1771.   
Jeppesen, E., B. Kronvang, M. Meerhoff, M. Søndergaard, K. M. Hansen, H. E. Andersen, T. L. Lauridsen, L. Liboriussen, M. Bekliog˘lu, A. Ozen & J. E. Olesen, 2009. Climate change effects on runoff, catchment phosphorus loading and lake ecological state, and potential adaptations. Journal of Environmental Quality 38: 1930–1941.   
Jeppesen, E., M. Søndergaard, T. L. Lauridsen, T. A. Davidson, Z. Liu, N. Mazzeo, C. Trochine, K. Ozkan, H. S. Jensen, D. Trolle, F. Starling, X. Lazzaro, L. S. Johansson, R. Bjerring, L. Liboriussen, S. E. Larsen, F. Landkildehus, S. Egemose & M. Meerhoff, 2012. Biomanipulation as a restoration tool to combat eutrophication: recent advances and future challenges. Advances in Ecological Research, Vol 47: Global Change in Multispecies Systems, Pt 2 47: 411–488.   
Jeppesen, E., M. Søndergaard & Z. Liu, 2017. Lake restoration and management in a climate change perspective: an introduction. Water 9: 122.   
Jilbert, T., S. Jokinen, T. Saarinen, U. Mattus-Kumpunen, A. Simojoki, S. Saarni, S. Salminen, J. Niemisto¨ & J. Horppila, 2020. Impacts of a deep reactive layer on sedimentary phosphorus dynamics in a boreal lake recovering from eutrophication. Hydrobiologia. https://doi.org/10.1007/ s10750-020-04289-9.   
Kasprzak, P., J. Benndorf, T. Gonsiorczyk, R. Koschel, L. Krienitz, T. Mehner, S. Hu¨uelsmann, H. Schultz & A. Wagner, 2007. Reduction of nutrient loading and biomanipulation as tools in water quality management: long-term observations on Bautzen Reservoir and Feldberger Haussee (Germany). Lake and Reservoir Management 23: 410–427.   
Katsev, S., 2017. When large lakes respond fast: a parsimonious model for phosphorus dynamics. Journal of Great Lakes Research 43: 199–204.   
Kristensen, P., C. Whalley, F. N. N. Zal & T. Christiansen, 2018. European Waters: assessment of status and pressures. https://doi.org/10.2800/303664.   
Kuha, J., M. Ja¨rvinen, P. Salmi & J. Karjalainen, 2020. Calibration of in situ chlorophyll fluorometers for organic matter. Hydrobiologia. https://doi.org/10.1007/s10750- 019-04086-z.   
Kuster, A. C., A. T. Kuster & B. J. Huser, 2020. A comparison of aluminum dosing methods for reducing sediment phosphorus release in lakes. Journal of Environmental Management 261: 110195.   
Lu¨rling, M. & M. Mucci, 2020. Mitigating eutrophication nuisance: in-lake measures are becoming inevitable in eutrophic waters in the Netherlands. Hydrobiologia. https://doi.org/10.1007/s10750-020-04297-9.   
Lu¨rling, M. & F. van Oosterhout, 2013. Controlling eutrophication by combined bloom precipitation and sediment phosphorus inactivation. Water Research 47: 6527–6537.   
Maavara, T., Q. Chen, K. Van Meter, L. E. Brown, J. Zhang, J. Ni & C. Zarfl, 2020. River dam impacts on biogeochemical cycling. Nature Reviews Earth and Environment 1: 103–116.   
Maranger, R., S. E. Jones & J. B. Cotner, 2018. Stoichiometry of carbon, nitrogen, and phosphorus through the freshwater pipe. Limnology and Oceanography Letters 3: 89–101.   
Markelov, I., R. Couture, R. Fischer, S. Haande & P. Van Cappellen, 2019. Coupling water column and sediment biogeochemical dynamics: modeling internal phosphorus loading, climate change responses, and mitigation measures in Lake Vansjø, Norway. Journal of Geophysical Research-Biogeosciences 124: 3847–3866.   
Marttila, H., A. Lepisto¨ , A. Tolvanen, M. Bechmann, K. Kyllmar, A. Juutinen, H. Wenng, E. Skarbøvik, M. Futter, P. Kortelainen, K. Rankinen, S. Hellsten, B. Kløve, B. Kronvang, Ø. Kaste, A. L. Solheim, J. Bhattacharjee, J. Rakovic & H. de Wit, 2020. Potential impacts of a future Nordic bioeconomy on surface water quality. Ambio 49: 1722–1735.   
Matisoff, G., E. M. Kaltenberg, R. L. Steely, S. K. Hummel, J. Seo, K. J. Gibbons, T. B. Bridgeman, Y. Seo, M. Behbahani, W. F. James, L. T. Johnson, P. Doan, M. Dittrich, M. A. Evans & J. D. Chaffin, 2016. Internal loading of phosphorus in western Lake Erie. Journal of Great Lakes Research 42: 775–788.   
Me, W., D. P. Hamilton, C. G. McBride, J. M. Abell & B. J. Hicks, 2018. Modelling hydrology and water quality in a mixed land use catchment and eutrophic lake: effects of nutrient load reductions and climate change. Environmental Modelling and Software 109: 114–133.   
Mehner, T., J. Benndorf, P. Kasprzak & R. Koschel, 2002. Biomanipulation of lake ecosystems: successful applications and expanding complexity in the underlying science. Freshwater Biology 47: 2453–2465.   
Mercier, P. & J. Perret, 1949. Station d’aeration au Lac de Bret. Schweiz Verein Gas Wasserfach Monatsbull 29: 25–30.   
Messina, N. J., R. Couture, S. A. Norton, S. D. Birkel & A. Amirbahman, 2020. Modeling response of water quality parameters to land-use and climate change in a temperate, mesotrophic lake. Science of the Total Environment 713: 136549.   
Niemisto¨, J., P. Ko¨ngas, L. Ha¨rkonen & J. Horppila, 2016. Hypolimnetic aeration intensifies phosphorus recycling and increases organic material sedimentation in a stratifying lake: effects through increased temperature and turbulence. Boreal Environment Research 21: 571–587.   
Niemisto¨, J., S. Silvonen & J. Horppila, 2020. Effects of hypolimnetic aeration on the quantity and quality of settling material in a eutrophied dimictic lake. Hydrobiologia. https://doi.org/10.1007/s10750-019-04160-6.   
Nu¨rnberg, G. K., 1987. Hypolimnetic withdrawal as a lake restoration technique. Society of Civil Engineers America. Journal of Environmental Engineering 113: 1006–1017.   
Nu¨rnberg, G. K., 2007. Lake responses to long-term hypolimnetic withdrawal treatments. Lake and Reservoir Management 23: 388–409. restoration technique: determination of feasibility and continued benefits. Hydrobiologia. https://doi.org/10.1007/ s10750-019-04094-z.   
Orihel, D. M., H. M. Baulch, N. J. Casson, R. L. North, C. T. Parsons, D. C. M. Seckar & J. J. Venkiteswaran, 2017. Internal phosphorus loading in Canadian fresh waters: a critical review and data analysis. Canadian Journal of Fisheries and Aquatic Sciences 74: 2005–2029.   
Paerl, H., 1997. Coastal eutrophication and harmful algal blooms: importance of atmospheric deposition and groundwater as ‘‘new’’ nitrogen and other nutrient sources. Limnology and Oceanography 42: 1154–1165.   
Paerl, H. W., J. T. Scott, M. J. McCarthy, S. E. Newell, W. S. Gardner, K. E. Havens, D. K. Hoffman, S. W. Wilhelm & W. A. Wurtsbaugh, 2016. It takes two to tango: when and where dual nutrient (N and P) reductions are needed to protect lakes and downstream ecosystems. Environmental Science and Technology 50: 10805–10813.   
Paerl, H. W., K. E. Havens, H. Xu, G. Zhu, M. J. McCarthy, S. E. Newell, J. T. Scott, N. S. Hall, T. G. Otten & B. Qin, 2020. Mitigating eutrophication and toxic cyanobacterial blooms in large lakes: the evolution of a dual nutrient (N and P) reduction paradigm. Hydrobiologia. https://doi.org/ 10.1007/s10750-019-04087-y.   
Rask, M., T. Malinen, M. Olin, H. Peltonen, J. Ruuhija¨rvi, S. Vesala & J. Hietala, 2020. Responses of the fish community in a eutrophicated lake to long-term food web management assessed by multiple sampling methods. Hydrobiologia. https://doi.org/10.1007/s10750-020- 04243-9.   
Reedyk, S., E. Prepas & P. Chambers, 2001. Effects of single $\mathrm { C a ( O H ) } _ { 2 }$ doses on phosphorus concentration and macrophyte biomass of two boreal eutrophic lakes over 2 years. Freshwater Biology 46: 1075–1087.   
Rousso, B. Z., E. Bertone, R. Stewart & D. P. Hamilton, 2020. A systematic literature review of forecasting and predictive models for cyanobacteria blooms in freshwater lakes. Water Research 182: 115959.   
Ruuhija¨rvi, J., T. Malinen, K. Kuoppama¨ki, P. Ala-Opas & M. Vinni, 2020. Responses of food web to hypolimnetic aeration in Lake Vesija¨rvi. Hydrobiologia. https://doi.org/10. 1007/s10750-020-04319-6.   
Salmi, P., I. Malin & K. Salonen, 2014. Pumping of epilimnetic water into hypolimnion improves oxygen but not necessarily nutrient conditions in a lake recovering from eutrophication. Inland Waters 4: 425–434.   
Salonen, K., J. Sarvala, J. Horppila, J. Keto, I. Malin, T. Malinen, J. Niemisto¨ & J. Ruuhija¨rvi, 2020. Development of Lake Vesija¨rvi through four decades of remediation efforts. Hydrobiologia. https://doi.org/10.1007/s10750-020- 04338-3.   
Sarvala, J., H. Helminen & J. Heikkila¨, 2020. Invasive submerged macrophytes complicate management of a shallow boreal lake: a 42-year history of monitoring and restoration attempts in Littoistenja¨rvi, SW Finland. Hydrobiologia. https://doi.org/10.1007/s10750-020-04318-7.   
Schauser, I. & I. Chorus, 2009. Water and phosphorus mass balance of Lake Tegel and Schlachtensee – a modelling approach. Water Research 43: 1788–1800.   
Scheffer, M., S. Hosper, M. Meijer, B. Moss & E. Jeppesen, 1993. Alternative equilibria in shallow lakes. Trends in Ecology and Evolution 8: 275–279.   
Schu¨tz, J., E. Rydin & B. J. Huser, 2017. A newly developed injection method for aluminum treatment in eutrophic lakes: effects on water quality and phosphorus binding efficiency. Lake and Reservoir Management 33: 152–162.   
Scott, J. T., M. J. McCarthy & H. W. Paerl, 2019. Nitrogen transformations differentially affect nutrient-limited primary production in lakes of varying trophic state. Limnology and Oceanography Letters 4: 96–104.   
Shapiro, J., V. Lamarra & M. Lynch, 1975. Biomanipulation: an ecosystem approach to lake restoration. In Brezonik, P. L. & J. L. Fox (eds), Water Quality Management Through Biological Control. University of Florida, Gainesville: 85–96.   
Sharpley, A., H. P. Jarvie, A. Buda, L. May, B. Spears & P. Kleinman, 2013. Phosphorus legacy: overcoming the effects of past management practices to mitigate future water quality impairment. Journal of Environmental Quality 42: 1308–1326.   
Shirokova, L. S., A. V. Chupakov, N. M. Kokryatskaya, K. V. Titova, S. I. Klimov, S. A. Zabelina, O. Y. Moreva, T. Y. Vorobieva & O. S. Pokrovsky, 2020. Variability of hydrochemical parameters of small boreal lakes under natural and anthropogenic factors (case study of NW Russia). Hydrobiologia. https://doi.org/10.1007/s10750- 020-04193-2.   
Singleton, V. L. & J. C. Little, 2006. Designing hypolimnetic aeration and oxygenation systems – a review. Environmental Science and Technology 40(24): 7512–7520.   
Sinha, E., A. M. Michalak & V. Balaji, 2017. Eutrophication will increase during the 21st century as a result of precipitation changes. Science 357: 405–408.   
Smith, V., 2003. Eutrophication of freshwater and coastal marine ecosystems – a global problem. Environmental Science and Pollution Research 10: 126–139.   
Smits, J. G. C. & J. K. L. van Beek, 2013. ECO: a generic eutrophication model including comprehensive sediment– water interaction. PLoS ONE. https://doi.org/10.1371/ journal.pone.0068104.   
Søndergaard, M., L. Liboriussen, A. R. Pedersen & E. Jeppesen, 2008. Lake restoration by fish removal: short- and longterm effects in 36 Danish Lakes. Ecosystems 11: 1291–1305.   
Spears, B. M., M. Lu¨rling, S. Yasseri, A. T. Castro-Castellon, M. Gibbs, S. Meis, C. McDonald, J. McIntosh, D. Sleep & F. Van Oosterhout, 2013. Lake responses following lanthanum-modified bentonite clay (Phoslock $^ \mathrm { \textregistered }$ ) application: an analysis of water column lanthanum data from 16 case study lakes. Water Research 47: 5930–5942.   
Spears, B. M., M. N. Futter, E. Jeppesen, B. J. Huser, S. Ives, T. A. Davidson, R. Adrian, D. G. Angeler, S. J. Burthe, L. Carvalho, F. Daunt, A. S. Gsell, D. O. Hessen, A. B. G. Janssen, E. B. Mackay, L. May, H. Moorhouse, S. Olsen, M. Søndergaard, H. Woods & S. J. Thackeray, 2017. Ecological resilience in lakes and the conjunction fallacy. Nature Ecology and Evolution 1: 1616–1624.   
Stumm, W. & J. J. Morgan, 1996. Aquatic Chemistry: Chemical Equilibria and Rates in Natural Waters, 3rd ed. Wiley, New York.   
Taipale, S. J., K. Kuoppama¨ki, U. Strandberg, E. Peltomaa & K. Vuorio, 2020. Lake restoration influences nutritional quality of algae and consequently Daphnia biomass. Hydrobiologia. https://doi.org/10.1007/s10750-020- 04398-5.   
Tong, Y., M. Wang, J. Penuelas, X. Liu, H. W. Paerl, J. J. Elser, J. Sardans, R. Couture, T. Larssen, H. Hu, X. Dong, W. He, W. Zhang, X. Wang, Y. Zhang, Y. Liu, S. Zeng, X. Kong, A. B. G. Janssen & Y. Lin, 2020. Improvement in municipal wastewater treatment alters lake nitrogen to phosphorus ratios in populated regions. Proceedings of the National Academy of Sciences of the United States of America 117: 11566–11572.   
Triest, L., I. Stiers & S. Van Onsem, 2016. Biomanipulation as a nature-based solution to reduce cyanobacterial blooms. Aquatic Ecology 50: 461–483.   
Trolle, D., D. P. Hamilton, C. A. Pilditch, I. C. Duggan & E. Jeppesen, 2011. Predicting the effects of climate change on trophic status of three morphologically varying lakes: implications for lake restoration and management. Environmental Modelling and Software 26: 354–370.   
United Nations, 2015. Resolution adopted by the General Assembly on 25 September 2015, Transforming Our World: The 2030 Agenda for Sustainable Development (A/ RES/70/1).   
Van Meter, K. J., N. B. Basu, J. J. Veenstra & C. L. Burras, 2016. The nitrogen legacy: emerging evidence of nitrogen accumulation in anthropogenic landscapes. Environmental Research Letters 11: 035014.   
Vennemo, H., K. Aunan, H. Lindhjem & H. M. Seip, 2009. Environmental pollution in China: status and trends. Review of Environmental Economics and Policy 3: 209–230.   
Vuorio, K., M. Ja¨rvinen & N. Kotama¨ki, 2020. Phosphorus thresholds for bloom-forming cyanobacterial taxa in boreal lakes. Hydrobiologia. https://doi.org/10.1007/s10750-019- 04161-5.   
Walker, W. W., C. E. Westerberg, D. J. Schuler & J. A. Bode, 1989. Design and evaluation of eutrophication control measures for the St. Paul water supply. Lake and Reservoir Management 5: 71–83.   
Weber, M. J., G. M. Wilkinson, M. B. Balmer & M. C. Bevil, 2020. Restoration of eutrophic lakes in Iowa, USA. Hydrobiologia. https://doi.org/10.1007/s10750-020- 04310-1.   
Wilson, M. & S. Carpenter, 1999. Economic valuation of freshwater ecosystem services in the United States: 1971–1997. Ecological Applications 9: 772–783.   
Yang, H., K. He, D. Lu, J. Wang, D. Xu, Z. Jin, M. Yang & J. Chen, 2020. Removal of phosphate by aluminum-modified clay in a heavily polluted lake, Southwest China: effectiveness and ecological risks. Science of The Total Environment 705: 135850.   
Yin, H. & M. Kong, 2015. Reduction of sediment internal P-loading from eutrophic lakes using thermally modified calcium-rich attapulgite-based thin-layer cap. Journal of Environmental Management 151: 178–185.   
Yin, H., P. Yang, M. Kong & W. Li, 2020. Use of lanthanum/ aluminum co-modified granulated attapulgite clay as a novel phosphorus (P) sorbent to immobilize P and stabilize surface sediment in shallow eutrophic lakes. Chemical Engineering Journal 385: 123395.   
Zhang, Z., B. Sun & B. E. Johnson, 2015. Integration of a benthic sediment diagenesis module into the two dimensional hydrodynamic and water quality model – CEQUAL-W2. Ecological Modelling 297: 213–231.

Publisher’s Note Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional affiliations.